#ifdef GL_ES
precision mediump float;

varying	vec3 lightVector, halfVector, lightVector2;
varying vec2 vTexCoord;

vec4 fragColor;
#else
in vec3 lightVector, halfVector, lightVector2;
in vec2 vTexCoord;

out vec4 fragColor;
#endif
uniform sampler2D normalTex;
uniform sampler2D colorTex;
uniform sampler2D normalZTex;
uniform float fade;

void main()
{
#ifdef GL_ES
	vec4 bumpSample = texture2D(normalTex, vTexCoord.st);
	vec3 bump = (vec3(bumpSample.xy, texture2D(normalZTex, vTexCoord.st).r) * 2.0 - 1.0);
	vec4 tColor = texture2D(colorTex, vTexCoord.st);
#else
    vec4 bumpSample = texture(normalTex, vTexCoord.st);
    vec3 bump = (vec3(bumpSample.xy, texture(normalZTex, vTexCoord.st).r) * 2.0 - 1.0);
    vec4 tColor = texture(colorTex, vTexCoord.st);
#endif

	float light1 = max(0.0, dot(bump, normalize(lightVector)));
	float lambert = sqrt(light1 * light1);
	vec3 diffuse = tColor.rgb * vec3(lambert);
	float specular = /*tColor.rgb*/ pow(max(0.0, dot(bump, normalize(halfVector))), 50.0) * bumpSample.z;

	fragColor = vec4((diffuse + vec3(specular)) * tColor.a, tColor.a) * fade;
#ifdef GL_ES
    gl_FragColor = fragColor;
#endif
}
